package cn.com.duiba.kjy.api.remoteservice.personalIntro;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.personalIntroTemplate.PersonalIntroTemplateDto;
import cn.com.duiba.kjy.api.params.personalIntro.PersonalIntroListParam;

import java.util.List;

/**
 * 个人介绍模版管理
 * @Author chentiecheng
 * @Date 2020/5/8 11:42 上午
 */
@AdvancedFeignClient
public interface RemotePersonalIntroTemplateService {

    /**
     * 统计总数
     * @param param
     * @return
     */
    Long selectCount(PersonalIntroListParam param);

    /**
     * 根据条件分页查询个人介绍模板
     * @param param
     * @return
     */
    List<PersonalIntroTemplateDto> selectListByParam(PersonalIntroListParam param);

    /**
     * 新增个人介绍模板
     * @param dto
     * @return
     */
    Boolean insert(PersonalIntroTemplateDto dto);

    /**
     * 更新个人介绍模板
     * @param dto
     * @return
     */
    Boolean update(PersonalIntroTemplateDto dto);

    /**
     * 删除个人介绍模板
     * @param id
     * @return
     */
    Boolean delete(Long id);
    /**
     * 根据id查询个人介绍模板
     * @param id
     * @return
     */
    PersonalIntroTemplateDto selectById(Long id);
}
