package cn.com.duiba.kjy.api.dto.activity;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;

/**
 * 活动扩展信息表
 * @author lizhi
 * @date 2019/10/23 5:00 PM
 */
@Data
public class ContentActivityExtDto implements Serializable {

    private static final long serialVersionUID = 15720776937503940L;

    /**
     * 主键
     */
    private Long id;

    /**
     * tb_content.id
     */
    private Long contentId;

    /**
     * 活动链接
     */
    private String activityUrl;

    /**
     * 活动简介
     */
    private String activityDes;

    /**
     * 活动预览图
     */
    private String previewImageUrl;

    /**
     * 记录类型：article =文章、seller =名片 activity =活动 daily=日报
     * @see cn.com.duiba.kjy.api.constant.ContentTypeEnum
     */
    private String contentType;

    /**
     * 活动类型
     * @see cn.com.duiba.kjy.api.enums.KjjActivityTypeEnum
     */
    private String activityType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 分享海报URL
     */
    private String sharePosterUrl;

    /**
     * 分享标题
     */
    private String shareTitle;

    /**
     * 分享描述
     */
    private String shareDesc;

    /**
     * 分享图片
     */
    private String sharePicUrl;

    public String getContentText() {
        ActivityExtDto activityExtDto = convert2ActivityExtDto();
        return JSON.toJSONString(activityExtDto);
    }

    public ActivityExtDto convert2ActivityExtDto() {
        ActivityExtDto activityExtDto = new ActivityExtDto();
        activityExtDto.setPreviewImageUrl(previewImageUrl);
        activityExtDto.setLottery(1);
        activityExtDto.setActivity_url(activityUrl);
        activityExtDto.setActivity_des(activityDes);
        return activityExtDto;
    }
}