package cn.com.duiba.kjy.api.enums.presentInsurance;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 赠险分类枚举
 * @author xiaotian
 * @date 2020/8/10 3:43 PM
 */
public enum PresentInsuranceEnum {

    ACCIDENT(1, "人身意外险","意外型赠险"),
    CRITICAL_ILLNESS(2,"重疾险","重疾型赠险"),
    EPIDEMIC(3,"疫情险","疫情型赠险")
    ;

    private Integer code;
    private String desc;
    private String pushDesc;

    PresentInsuranceEnum(Integer code, String desc,String pushDesc) {
        this.code = code;
        this.desc = desc;
        this.pushDesc = pushDesc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getPushDesc() {
        return pushDesc;
    }

    private static final Map<Integer, PresentInsuranceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PresentInsuranceEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static PresentInsuranceEnum getByCode(Integer code) {
        PresentInsuranceEnum preInstallBatchStatusEnum = ENUM_MAP.get(code);
        if(Objects.isNull(preInstallBatchStatusEnum)){
            return null;
        }
        return preInstallBatchStatusEnum;
    }
}
