package cn.com.duiba.kjy.api.dto.seller;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhanghuifeng
 * date 2019-05-20-17:28
 */
public class SellerAccountDto implements Serializable {
    private static final long serialVersionUID = 7642273040461921106L;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 累计推广收益(分)
     */
    private Integer totalPromotionEarnings;

    /**
     * 余额(分)
     */
    private Integer balance;

    /**
     * 待结算金额（分）
     */
    private Integer settleMoney;

    /**
     * 最近一次提现操作时间
     */
    private Date withdrawData;

    /**
     * 提现开关状态，1:打开；2:关闭
     * @see cn.com.duiba.kjy.api.enums.seller.WithdrawSwitchEnum
     */
    private Integer withdrawSwitch;

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getTotalPromotionEarnings() {
        return totalPromotionEarnings;
    }

    public void setTotalPromotionEarnings(Integer totalPromotionEarnings) {
        this.totalPromotionEarnings = totalPromotionEarnings;
    }

    public Integer getBalance() {
        return balance;
    }

    public void setBalance(Integer balance) {
        this.balance = balance;
    }

    public Date getWithdrawData() {
        return withdrawData;
    }

    public void setWithdrawData(Date withdrawData) {
        this.withdrawData = withdrawData;
    }

    public Integer getWithdrawSwitch() {
        return withdrawSwitch;
    }

    public void setWithdrawSwitch(Integer withdrawSwitch) {
        this.withdrawSwitch = withdrawSwitch;
    }

    public Integer getSettleMoney() {
        return settleMoney;
    }

    public void setSettleMoney(Integer settleMoney) {
        this.settleMoney = settleMoney;
    }
}
