package cn.com.duiba.kjy.api.enums.content;

import org.apache.commons.lang.StringUtils;

/**
 * @author wangbinbin
 * @create 2020-01-02 11:20
 * @descript
 */
public enum EsContentSearchSortEnum {
    READ_NUM("readNum", "根据访问数排序"),
    SHARE_NUM("shareNum", "根据分享数排序"),
    SEllER_FORWARD_RATE("sellerForwardRate", "根据代理人转发率排序");

    private String sortField;

    private String description;

    EsContentSearchSortEnum(String sortField, String description) {
        this.sortField = sortField;
        this.description = description;
    }

    public String getSortField() {
        return sortField;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据排序字段返回
     * @param sortField
     * @return
     */
    public static EsContentSearchSortEnum getBySortField(String sortField) {
        for (EsContentSearchSortEnum esEnum : EsContentSearchSortEnum.values()) {
            if (StringUtils.equals(esEnum.getSortField(), sortField)) {
                return esEnum;
            }
        }
        return null;
    }
}
