package cn.com.duiba.kjy.api.enums.shareEntrance;

import java.util.stream.Stream;

/**
 * 分享入口配置内容类型枚举
 * @author 小天
 * date 2019-07-19-17:13
 */
public enum ShareEntranceContentTypeEnum {
    /**
     * 早报
     */
    DAILY(1, "daily"),
    /**
     * 文章
     */
    ARTICLE(2, "article"),
    ;
    private Integer code;

    private String desc;

    ShareEntranceContentTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static ShareEntranceContentTypeEnum getEnum(Integer contentType){
      return Stream.of(ShareEntranceContentTypeEnum.values()).filter(shareEntranceContentTypeEnum -> shareEntranceContentTypeEnum.getCode().equals(contentType)).findFirst().orElse(null);
    }

    public static ShareEntranceContentTypeEnum getByContentType(String contentType){
        return Stream.of(ShareEntranceContentTypeEnum.values()).filter(shareEntranceContentTypeEnum -> shareEntranceContentTypeEnum.getDesc().equals(contentType)).findFirst().orElse(null);
    }
}
