/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.material;

import cn.com.duiba.kjy.api.enums.interaction.InteractionSourceEnum;
import cn.com.duiba.kjy.api.enums.interaction.InteractionTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum SellerCustomerMaterialTypeEnum {
    INTERACTION_ANSWER_SINGLE(100, "\u95ee\u7b54\u9898\u5355\u9009"),
    INTERACTION_ANSWER_MULTIPLE(101, "\u95ee\u7b54\u9898\u591a\u9009"),
    INTERACTION_VOTE_PK(102, "\u6295\u7968PK"),
    INTERACTION_VOTE_SINGLE(103, "\u6295\u7968\u5355\u9009"),
    INTERACTION_VOTE_MULTIPLE(104, "\u6295\u7968\u591a\u9009"),
    INTERACTION_TEMPLATE_ANSWER_SINGLE(110, "\u4e92\u52a8\u9898\u5e93\u95ee\u7b54\u9898\u5355\u9009"),
    INTERACTION_TEMPLATE_ANSWER_MULTIPLE(111, "\u4e92\u52a8\u9898\u5e93\u95ee\u7b54\u9898\u591a\u9009"),
    INTERACTION_TEMPLATE_VOTE_PK(112, "\u4e92\u52a8\u9898\u5e93\u6295\u7968PK"),
    INTERACTION_TEMPLATE_VOTE_SINGLE(113, "\u4e92\u52a8\u9898\u5e93\u6295\u7968\u5355\u9009"),
    INTERACTION_TEMPLATE_VOTE_MULTIPLE(114, "\u4e92\u52a8\u9898\u5e93\u6295\u7968\u591a\u9009"),
    INTERACTION_SELLER_TEMPLATE_ANSWER_SINGLE(120, "\u9500\u552e\u5458\u6a21\u677f\u7b54\u9898\u5355\u9009"),
    INTERACTION_SELLER_TEMPLATE_ANSWER_MULTIPLE(121, "\u9500\u552e\u5458\u6a21\u677f\u7b54\u9898\u591a\u9009"),
    INTERACTION_SELLER_TEMPLATE_VOTE_PK(122, "\u9500\u552e\u5458\u6a21\u677f\u6295\u7968PK"),
    INTERACTION_SELLER_TEMPLATE_VOTE_SINGLE(123, "\u9500\u552e\u5458\u6a21\u677f\u6295\u7968\u5355\u9009"),
    INTERACTION_SELLER_TEMPLATE_VOTE_MULTIPLE(124, "\u9500\u552e\u5458\u6a21\u677f\u6295\u7968\u591a\u9009"),
    INTERACTION_SELLER_ANSWER_SINGLE(130, "\u9500\u552e\u5458\u914d\u7f6e\u7b54\u9898\u5355\u9009"),
    INTERACTION_SELLER_ANSWER_MULTIPLE(131, "\u9500\u552e\u5458\u914d\u7f6e\u7b54\u9898\u591a\u9009"),
    INTERACTION_SELLER_VOTE_PK(132, "\u9500\u552e\u5458\u914d\u7f6e\u6295\u7968PK"),
    INTERACTION_SELLER_VOTE_SINGLE(133, "\u9500\u552e\u5458\u914d\u7f6e\u6295\u7968\u5355\u9009"),
    INTERACTION_SELLER_VOTE_MULTIPLE(134, "\u9500\u552e\u5458\u914d\u7f6e\u6295\u7968\u591a\u9009"),
    INTERACTION_MID_AUTUMN(200, "19\u5e74\u4e2d\u79cb\u6233\u4e00\u4e0b"),
    INTERACTION_LIKE(201, "\u70b9\u8d5e"),
    INTERACTION_NATIONAL_DAY(202, "19\u5e74\u56fd\u5e86\u9886\u795d\u798f"),
    EXPLOSION_VOTE_SINGLE(53, "\u79cd\u8349\u8d44\u6e90\u4f4d\u5355\u9009"),
    EXPLOSION_VOTE_MULTIPLE(54, "\u79cd\u8349\u8d44\u6e90\u4f4d\u591a\u9009"),
    GAME_SEND_INFO(-1, "\u5c0f\u6e38\u620f\u63d0\u4ea4\u8d44\u6599");

    private Integer type;
    private String desc;
    private static final Map<Integer, SellerCustomerMaterialTypeEnum> ENUM_MAP;

    private SellerCustomerMaterialTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isInteraction() {
        return 0 < this.getType() && this.getType() < 200;
    }

    public static List<Integer> getAllInteraction() {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (SellerCustomerMaterialTypeEnum val : SellerCustomerMaterialTypeEnum.values()) {
            if (0 >= val.getType() || val.getType() >= 200) continue;
            resultList.add(val.getType());
        }
        return resultList;
    }

    public static List<Integer> getAllOptionInteraction() {
        return Arrays.asList(SellerCustomerMaterialTypeEnum.INTERACTION_ANSWER_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_ANSWER_MULTIPLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_TEMPLATE_ANSWER_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_TEMPLATE_ANSWER_MULTIPLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_TEMPLATE_ANSWER_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_TEMPLATE_ANSWER_MULTIPLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_ANSWER_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_ANSWER_MULTIPLE.type);
    }

    public static List<Integer> getAllVoteInteraction() {
        return Arrays.asList(SellerCustomerMaterialTypeEnum.INTERACTION_VOTE_PK.type, SellerCustomerMaterialTypeEnum.INTERACTION_VOTE_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_VOTE_MULTIPLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_TEMPLATE_VOTE_PK.type, SellerCustomerMaterialTypeEnum.INTERACTION_TEMPLATE_VOTE_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_TEMPLATE_VOTE_MULTIPLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_TEMPLATE_VOTE_PK.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_TEMPLATE_VOTE_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_TEMPLATE_VOTE_MULTIPLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_VOTE_PK.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_VOTE_SINGLE.type, SellerCustomerMaterialTypeEnum.INTERACTION_SELLER_VOTE_MULTIPLE.type, SellerCustomerMaterialTypeEnum.EXPLOSION_VOTE_SINGLE.type, SellerCustomerMaterialTypeEnum.EXPLOSION_VOTE_MULTIPLE.type);
    }

    public static boolean isManagerOption(Integer type) {
        SellerCustomerMaterialTypeEnum typeEnum = SellerCustomerMaterialTypeEnum.getByType(type);
        return Objects.nonNull((Object)typeEnum) && (typeEnum.equals((Object)INTERACTION_ANSWER_SINGLE) || typeEnum.equals((Object)INTERACTION_ANSWER_MULTIPLE));
    }

    public static boolean isManagerVote(Integer type) {
        SellerCustomerMaterialTypeEnum typeEnum = SellerCustomerMaterialTypeEnum.getByType(type);
        return Objects.nonNull((Object)typeEnum) && (typeEnum.equals((Object)INTERACTION_VOTE_PK) || typeEnum.equals((Object)INTERACTION_VOTE_SINGLE) || typeEnum.equals((Object)INTERACTION_VOTE_MULTIPLE));
    }

    public static SellerCustomerMaterialTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    @Deprecated
    public static SellerCustomerMaterialTypeEnum getByInteractionTypeEnum(InteractionTypeEnum interactionTypeEnum) {
        if (interactionTypeEnum == null) {
            return null;
        }
        Integer type = (int)interactionTypeEnum.getType();
        return SellerCustomerMaterialTypeEnum.getByType(type + 100);
    }

    public static SellerCustomerMaterialTypeEnum getByInteractionTypeEnumAndSourceEnum(InteractionTypeEnum interactionTypeEnum, InteractionSourceEnum sourceEnum) {
        if (interactionTypeEnum == null || sourceEnum == null) {
            return null;
        }
        Integer type = (int)interactionTypeEnum.getType();
        Integer source = sourceEnum.getSource();
        Integer materialType = Objects.equals(source, InteractionSourceEnum.EXPLOSION_CONTENT_RESOURCE.getSource()) ? Integer.valueOf(Integer.parseInt("" + source + type)) : Integer.valueOf(Integer.parseInt("1" + source + type));
        return SellerCustomerMaterialTypeEnum.getByType(materialType);
    }

    static {
        ENUM_MAP = new HashMap<Integer, SellerCustomerMaterialTypeEnum>();
        for (SellerCustomerMaterialTypeEnum typeEnum : SellerCustomerMaterialTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

