package cn.com.duiba.kjy.api.enums.seller;

/**
 * 销售vip状态
 * @author zhanghuifeng
 * date 2019-05-17-11:09
 */
public enum SellerVipStatusEnum {

    NO_VIP(0, "非会员"),
    VIP(1, "会员"),
    ;
    private Integer code;

    private String desc;

    SellerVipStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerVipStatusEnum getByCode(Integer code) {
        for (SellerVipStatusEnum enumVal : SellerVipStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerVipStatusEnum enumVal : SellerVipStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
