package cn.com.duiba.kjy.api.enums.layer;

import java.util.HashMap;
import java.util.Map;

/**
 * 1:全部，2:VIP 3:非VIP 4:company
 * @author 吴文哲
 * @date 2020-03-25 17:42
 **/
public enum LayerSellerFilterTypeEnum {

    ALL(1,"全部"),
    VIP(2,"vip"),
    NOT_VIP(3,"非vip"),
    COMPANY(4,"公司"),
    CUSTOM(5,"自定义推送用户")
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LayerSellerFilterTypeEnum(Integer type ,String desc){
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LayerSellerFilterTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LayerSellerFilterTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }
    public static LayerSellerFilterTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
