package cn.com.duiba.kjy.api.dto.fission;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理发起的裂变活动记录表
 *
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月29日 17:46
 **/
@Data
@ToString
public class FissionActivityDto implements Serializable {

    private static final long serialVersionUID = -3904412866138123456L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 奖品id
     */
    private Long awardId;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 目标助力数
     */
    private Integer targetAssistanceNum;

    /**
     * 参与数
     */
    private Integer partakeNum;

    /**
     * 转发数
     */
    private Integer forwardNum;

    /**
     * 完成数
     */
    private Integer finishNum;

    /**
     * 代理人海报分享资源地址
     */
    private String imageUrl;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 扫码人数
     */
    private Integer scanNum;

    /**
     * 试听人数
     */
    private Integer auditionNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更改时间
     */
    private Date gmtModified;

}
