/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.pay;

import cn.com.duiba.kjy.api.enums.pay.WxCompanyPayStatusEnum;
import java.util.HashMap;
import java.util.Map;

public enum CompanyPayStatusEnum {
    INIT(0, "\u521d\u59cb\u5316\u72b6\u6001"),
    PROCESSING(1, "\u5904\u7406\u4e2d"),
    SUCCESS(2, "\u8f6c\u8d26\u6210\u529f"),
    FAILED(3, "\u8f6c\u8d26\u5931\u8d25"),
    CALL_FAILED(4, "\u8c03\u7528\u5fae\u4fe1\u5931\u8d25");

    private Integer code;
    private String desc;
    private static final Map<Integer, CompanyPayStatusEnum> ENUM_MAP;

    private CompanyPayStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public static CompanyPayStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static CompanyPayStatusEnum getByWxStatus(String wxStatus) {
        if (wxStatus == null) {
            return null;
        }
        WxCompanyPayStatusEnum statusEnum = WxCompanyPayStatusEnum.getByCode(wxStatus);
        if (statusEnum == null) {
            return null;
        }
        switch (statusEnum) {
            case SUCCESS: {
                return SUCCESS;
            }
            case FAILED: {
                return FAILED;
            }
            case PROCESSING: {
                return PROCESSING;
            }
        }
        return null;
    }

    public static boolean isFinal(Integer code) {
        CompanyPayStatusEnum statusEnum = CompanyPayStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == SUCCESS || statusEnum == FAILED || statusEnum == CALL_FAILED;
    }

    static {
        ENUM_MAP = new HashMap<Integer, CompanyPayStatusEnum>();
        for (CompanyPayStatusEnum tmp : CompanyPayStatusEnum.values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }
}

