package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerCustomRemind.SellerCustomRemindDto;
import cn.com.duiba.kjy.api.params.seller.SellerCustomRemindParam;

import java.util.List;

/**
 * 销售客户自定义提醒管理
 * @Author chentiecheng
 * @Date 2020/6/8 4:13 下午
 */
@AdvancedFeignClient
public interface RemoteSellerCustomRemindService {
    /**
     * 根据参数获取总数
     * @param param
     * @return
     */
    Long countByParam(SellerCustomRemindParam param);

    /**
     * 根据参数获取列表
     * @param param
     * @return
     */
    List<SellerCustomRemindDto> getListByParam(SellerCustomRemindParam param);

    /**
     * 根据id获取自定义提醒
     * @param id
     * @return
     */
    SellerCustomRemindDto getById(Long id);
    /**
     * 删除自定义提醒
     * @param id
     * @return
     */
    Boolean deleteCustomRemind(Long id);

    /**
     * 新增编辑自定义提醒
     * @param dto
     * @return
     */
    Long addOrUpdateCustomRemind(SellerCustomRemindDto dto);
}
