package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.push.PushManagerDetailDto;
import cn.com.duiba.kjy.api.dto.push.PushManagerDto;
import cn.com.duiba.kjy.api.params.push.PushManagerSearchParam;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2019-08-06 14:31
 * @description: 推送管理
 */
@AdvancedFeignClient
public interface RemotePushManagerService {

    /**
     * 查询推送管理列表
     *
     * @param param
     * @return
     */
    List<PushManagerDto> selectList(PushManagerSearchParam param);

    /**
     * 查询列表条数
     *
     * @param param
     * @return
     */
    Long selectCount(PushManagerSearchParam param);

    /**
     * 插入推送管理
     *
     * @param pushManagerDto
     * @return
     */
    Long insert(PushManagerDto pushManagerDto);

    /**
     * 更新推送管理
     *
     * @param pushManagerDto
     * @return
     */
    Integer update(PushManagerDto pushManagerDto);

    /**
     * 根据日期及场景获取推送
     * @param startDate
     * @param endDate
     * @param scenes
     * @return
     */
    PushManagerDto findPushByDateAndType(String startDate, String endDate, Integer scenes);

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    PushManagerDto findById(Long id);

    /**
     * 查询详情，包括降级配置
     * @param id
     * @return
     */
    PushManagerDetailDto findDetailById(Long id);

    /**
     * 新增，包括降级配置
     * @param dto
     * @return
     */
    Long insertDetail(PushManagerDetailDto dto);

    /**
     * 跟新包括降级配置
     * @param dto
     * @return
     * @throws KjyCenterException
     */
    Integer updateDetail(PushManagerDetailDto dto) throws KjyCenterException;

    /**
     * 是否启用推送
     *
     * @param id
     * @param enable
     * @return
     */
    Integer openPush(Long id, Integer enable);

    /**
     * 根据推送id删除
     * @param pushId
     * @return
     */
    Boolean deleteById(Long pushId);

}
