package cn.com.duiba.kjy.api.dto.privatechat;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangbinbin
 * @create 2020-02-07 13:55
 * @descript 私信消息simpleDto
 */
@Data
public class PrivateChatRecordSimpleDto implements Serializable {

    /**
     * 私信消息id
     */
    private Long id;

    /**
     * 私信业务关联类型
     * @see cn.com.duiba.kjy.api.enums.privatechat.PrivateChatBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务关联id
     */
    private Long bizId;

    /**
     * 发送人角色
     * @see cn.com.duiba.kjy.api.constant.UserRoleEnum
     */
    private Integer senderRole;

}
