package cn.com.duiba.kjy.api.enums;

/**
 * @author linjianhui
 * @description  tb_item_company名单类型
 *               名单类型,1=黑名单,0=白名单
 * @date 2019-07-17 14:36
 */
public enum CompanyListTypeEnum {

    BLACKLIST(1, "黑名单"),
    WHITELIST(0, "白名单"),
    ;
    private int code;

    private String desc;

    CompanyListTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static CompanyListTypeEnum getByCode(int code) {
        for (CompanyListTypeEnum enumVal : CompanyListTypeEnum.values()) {
            if (enumVal.getCode()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        for (CompanyListTypeEnum enumVal : CompanyListTypeEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
