package cn.com.duiba.kjy.api.remoteservice.supervisor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.supervisor.SupervisorConfigDto;
import cn.com.duiba.kjy.api.dto.supervisor.SupervisorConfigSimpleDto;
import cn.com.duiba.kjy.api.params.supervisor.SupervisorConfigParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-02 11:21
 * @descript 导师配置remoteService
 */
@AdvancedFeignClient
public interface RemoteSupervisorConfigService {

    /**
     * 新增获更新导师配置
     * @param supervisorConfigDto
     * @return
     */
    int addOrUpdate(SupervisorConfigDto supervisorConfigDto);

    /**
     * 根据主键删除
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 更改导师配置状态
     * @param id
     * @param openCode
     * @see cn.com.duiba.kjy.api.enums.supervisor.SupervisorOpenEnum
     * @return
     */
    int editOpenStatus(Long id, Integer openCode);

    /**
     * 分页查询导师
     * @param param 导师查询param
     * @return
     */
    List<SupervisorConfigDto> listSupervisorConfigs(SupervisorConfigParam param);

    /**
     * 查询有效导师总数
     * @param param 导师查询param
     * @return
     */
    int countSupervisorConfigs(SupervisorConfigParam param);

    /**
     * 根据当前用户获取对应的导师
     * @param userId
     * @param userVersion 用户版本
     * @param autoExposed 是否自动曝光
     * @return
     */
    SupervisorConfigSimpleDto getUsingConfig(Long userId, Integer userVersion, boolean autoExposed);

    /**
     * 根据主键曝光导师二维码
     * @param id
     * @return
     */
    int exposedSuperviosrQrCode(Long id);

    /**
     * 点击识别导师二维码
     * @param id
     * @return
     */
    int clickSuperviosrQrCode(Long id);
}
