package cn.com.duiba.kjy.api.remoteservice.exclusive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveAreaItemDto;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveAreaItemValidCountDto;
import cn.com.duiba.kjy.api.enums.exclusive.ExclusiveAreaItemSortOperateEnum;
import cn.com.duiba.kjy.api.params.exclusive.ExclusiveAreaItemQryParams;

import java.util.List;
import java.util.Map;

/**
 * 专区内容remote
 * @author zhanghuifeng
 * date 2019-04-29-20:06
 */
@AdvancedFeignClient
public interface RemoteExclusiveAreaItemService {

    /**
     * 分页查询数据
     * @param params
     * @return
     */
    List<ExclusiveAreaItemDto> findPageList(ExclusiveAreaItemQryParams params);

    /**
     * 分页查询 获取总数
     * @param params
     * @return
     */
    int findPageCount(ExclusiveAreaItemQryParams params);

    /**
     * 上移或者下移
     * @param id      主键ID
     * @param operate 操作方式；1=上移 2=下移
     * @see ExclusiveAreaItemSortOperateEnum
     * @return
     */
    Boolean move(Long id, int operate);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 添加
     * @param dto
     * @return
     */
    Boolean add(ExclusiveAreaItemDto dto);

    /**
     * 编辑
     * @param dto
     * @return
     */
    Boolean update(ExclusiveAreaItemDto dto);

    /**
     * 批量获取专区有效内容数
     * @param exclusiveAreaIds
     * @return
     */
    List<ExclusiveAreaItemValidCountDto> findValidCountByAreaIds(List<Long> exclusiveAreaIds);

    /**
     * 获取专区有效内容数
     * @param exclusiveAreaId
     * @return
     */
    int findValidCountByAreaId(Long exclusiveAreaId);

    /**
     * 查询
     * @param id
     * @return
     */
    ExclusiveAreaItemDto find(Long id);

    /**
     * 查询
     * @param ids
     * @return
     */
    Map<Long, ExclusiveAreaItemDto> findByIds(List<Long> ids);

    /**
     * 根据专区id 素材id列表查询专区内容
     * @param areaId
     * @param contentIds
     * @return
     */
    List<ExclusiveAreaItemDto> findByAreaIdAndContentIds(Long areaId,List<Long> contentIds);
}
