package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.CustomPushConfDto;
import cn.com.duiba.kjy.api.dto.push.CustomPushManagerDto;
import cn.com.duiba.kjy.api.dto.push.CustomPushMsgDto;
import cn.com.duiba.kjy.api.params.push.CustomPushListParam;
import cn.com.duiba.kjy.api.params.push.CustomPushOpenOrCloseParam;

import java.util.List;

/**
 * 自定义推送 rpc接口
 * @author 吴文哲
 * @date 2020-07-24 16:21
 **/
@AdvancedFeignClient
public interface RemoteCustomPushService {


    /**
     * 新增自定义推送
     * @param customPushManagerDto
     * @return
     */
    Boolean  insertCustomPush(CustomPushManagerDto customPushManagerDto);


    /**
     * 修改自定义推送
     * @param customPushManagerDto
     * @return
     */
    Boolean updateCustomPush(CustomPushManagerDto customPushManagerDto);


    /**
     * 根据条件查询列表
     * @param param
     * @return
     */
    List<CustomPushConfDto> listByCondition(CustomPushListParam param);

    /**
     * 自定义推送启用/关闭
     * @param param
     * @return
     */
    Boolean openOrClose(CustomPushOpenOrCloseParam param);

    /**
     * 根据主键逻辑删除自定义推送
     * @return
     */
    Boolean delCustomPushById(Long pushId);

    /**
     * 根据条件统计总数
     * @param param
     * @return
     */
    Integer countByCondition(CustomPushListParam param);

    /**
     * 根据自定义推送配置id查询
     * @param pushId 自定义推送主键id
     * @return
     */
    CustomPushConfDto findPushConfById(Long pushId);

    /**
     * 根据自定义推送主键id查询消息列表
     * @param pushId
     * @return
     */
    List<CustomPushMsgDto> findPushMsgListByPushId(Long pushId);

}
