package cn.com.duiba.kjy.api.remoteservice.sellercard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellercard.UserCollectCardDto;
import cn.com.duiba.kjy.api.params.sellercard.UserCollectCardParam;

import java.util.List;

/**
 * Created by dugq on 2019-08-02.
 */
@AdvancedFeignClient
public interface RemoteUserCollectCardService {

    UserCollectCardDto selectOne(Long id);

    List<UserCollectCardDto> selectList(UserCollectCardParam pojo);

    Integer selectCount(UserCollectCardParam pojo);

    /**
     * 0 收藏 失败  -1 不支持的类型 -2重复收藏
     * @param uid
     * @param scId
     * @return
     */
    int collect(Long uid, Long scId);

    Integer delete(Long id);
}
