package cn.com.duiba.kjy.api.dto.clockin;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 打卡每日进度表
 *
 * @author xuzhigang
 */
@Data
public class SellerClockInDayProgressDto implements Serializable {

    private static final long serialVersionUID = 8095049735731733432L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 打卡id id tb_seller_clock_in_progress.id
     */
    private Long clockInProgressId;

    /**
     * 每日任务状态 1-进行中 2-完成 3-失败
     *
     * @see cn.com.duiba.kjy.api.enums.clockin.DailyClockInStatusEnum
     */
    private Integer dayStatus;

    /**
     * 完成日期
     */
    private Date doneTime;
}

