package cn.com.duiba.kjy.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户多度人脉来源表
 * @author kjj mybatis generator 
 * 2020-08-17
 */
@Data
public class UserMultiConnectDto implements Serializable {
    private static final long serialVersionUID = 15976302980054973L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     *
     *访客ID，对应tb_users.id
     * not null default = null
     */
    private Long visitorId;

    /**
     *
     *代理人ID，对应tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *销售员内容ID，对应tb_seller_content.id
     * not null default = null
     */
    private Long scId;

    /**
     *
     *访客用户链路列表，记录从源头开始的用户id，以，分割
     * max length = 512
     * not null default = null
     */
    private String connectList;
}