package cn.com.duiba.kjy.api.params.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmCompanyGradeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmCompanyTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhanghuifeng
 * date 2020/12/7-11:31
 */
@Data
public class CrmCompanyAddParam implements Serializable {
    private static final long serialVersionUID = -2204826281298590601L;
    /**
     * 公司等级,1总公司,2分公司,3中心支公司 {@link CrmCompanyGradeEnum}
     */
    private Integer companyGrade;

    /**
     * 上级公司ID
     */
    private Long parentCompanyId;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司类型，1标准客户,2重点客户
     * @see CrmCompanyTypeEnum
     */
    private Integer companyType;

    /**
     * 公司地址
     */
    private String companyAddress;
}
