package cn.com.duiba.kjy.api.remoteservice.accurate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.AccurateContentDetailDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.accurate.AccurateListParam;

import java.util.List;

/**
 * 精准素材文章库功能类
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteAccurateContentService {

    /**
     * 获取当前tag的文章数量
     * @param firstTagIds
     * @param companyId
     * @return
     */
    Long countByFirstTagId(List<Long> firstTagIds, Long companyId);

    /**
     * 根据内容ids (不包含不可用的)
     * @param contentIds
     * @return
     */
    List<AccurateContentDetailDto> listByContentIds(List<Long> contentIds);

    /**
     * 根据内容ids查询所有 (包含不可用的)
     * @param contentIds
     * @return
     */
    List<AccurateContentDetailDto> listAllByContentIds(List<Long> contentIds);

    /**
     * 新增
     * @param accurateContentDetailDto
     * @return
     */
    Boolean save(AccurateContentDetailDto accurateContentDetailDto);

    /**
     * 根据内容id更新
     * @param accurateContentDetailDto
     * @return
     */
    Integer updateByContentId(AccurateContentDetailDto accurateContentDetailDto);

    /**
     * 根据内容id删除
     * @param contentId
     * @return
     */
    Boolean deleteByContentId(Long contentId);

    /**
     * 根据内容id删除 物理删除
     * @param contentId
     * @return
     */
    Boolean deleteByContent(Long contentId);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<AccurateContentDetailDto> findByPage(AccurateListParam param);

    /**
     * 查询销售对应公司对产品文章
     * @param param
     * @return
     */
    AccurateContentDetailDto findProductByCompanyId(AccurateListParam param);

    /**
     * 分页查询总数
     * @param param
     * @return
     */
    Integer countByPage(AccurateListParam param);

    /**
     * 上下移动
     * @param sourceContentId
     * @param targetContentId
     * @return
     */
    Boolean move(Long sourceContentId, Long targetContentId);

    /**
     * 根据contentSort找到上一个或下一个
     * @param param
     * @return
     */
    AccurateContentDetailDto findPreOrNextSort(AccurateListParam param);

    /**
     * 获取contentIds里的精准素材id
     * @param contentIds
     * @return
     */
    List<Long> getAccurateContentIds(List<Long> contentIds);

    /**
     * 根据contentIds 查询精准素材列表
     * tb_accurate_content 中 content_id具有唯一约束
     * @param contentIds
     * @return
     */
    List<AccurateContentDetailDto> findByContentIds(List<Long> contentIds);

    /**
     * 根据素材id 查询精准素材
     * 只查可用的数据 过滤 content_status = 0 的数据
     * @param contentId
     * @see cn.com.duiba.kjy.api.enums.accurate.AccurateContentStatusEnum
     * @return
     */
    AccurateContentDetailDto findByContentId(Long contentId,Integer status);

    /**
     *根据条件查询记录的总记录数
     *
     */
    Integer selectCount(Long contentId);

}
