package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-07-09 10:42
 * @descript 代理人转发排序枚举
 */
public enum SellerForwardEsOrderTypeEnum {

    LAST_FORWARD(1, "按最近转发时间排序"),
    VISIT_NUM(2, "按访问次数排序"),
    CLUE_NUM(3, "按获得线索次数排序");

    private Integer code;

    private String description;

    SellerForwardEsOrderTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据代码查询
     * @param code
     * @return
     */
    public static SellerForwardEsOrderTypeEnum getByCode(Integer code) {
        for (SellerForwardEsOrderTypeEnum sellerForwardEsOrderTypeEnum : SellerForwardEsOrderTypeEnum.values()) {
            if (Objects.equals(sellerForwardEsOrderTypeEnum.code, code)) {
                return sellerForwardEsOrderTypeEnum;
            }
        }
        return null;
    }
}
