package cn.com.duiba.kjy.api.enums.whosawme;

import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 客户线索类型
 * @Author chentiecheng
 * @Date 2020/4/26 10:17 上午
 */
public enum UserClueTypeEnum {
    COMPLETE_INFO(3,"完善资料",null),
    CUSTOMER_FORWARD(4,"转发",null),
    ;
    /**
     * 分类类型以及在二进制中存在的位置，从后往前数
     */
    private Integer code;
    private String desc;
    /**
     * 该分类下的子线索
     */
    private List<Integer> subClue;

    UserClueTypeEnum(Integer code, String desc, List<Integer> subClue) {
        this.code = code;
        this.desc = desc;
        this.subClue = subClue;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public List<Integer> getSubClue() {
        return subClue;
    }

    /**
     * 根据code 获得 子线索
     * @param code
     * @return
     */
    public static List<Integer> getSubClueByCode(Integer code){
        if(Objects.isNull(code)){
            return null;
        }
        for (UserClueTypeEnum clueTypeEnum : UserClueTypeEnum.values()) {
            if (Objects.equals(clueTypeEnum.code, code)) {
                return clueTypeEnum.getSubClue();
            }
        }

        return null;
    }

    /**
     * 根据子分类查询所属大分类
     * @param clueType
     * @return
     */
    public static UserClueTypeEnum getBySubClue(Integer clueType){
        if(Objects.isNull(clueType)){
            return null;
        }
        for (UserClueTypeEnum clueTypeEnum : UserClueTypeEnum.values()) {
            if(CollectionUtils.isEmpty(clueTypeEnum.getSubClue())){
                continue;
            }
            if (clueTypeEnum.getSubClue().contains(clueType)) {
                return clueTypeEnum;
            }
        }

        return null;
    }
}
