package cn.com.duiba.kjy.api.params.redpacket;

import cn.com.duiba.kjy.api.enums.redpacket.SellerPromotionStateEnum;
import cn.com.duiba.kjy.api.enums.redpacket.SellerPromotionTypeEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liuchao1
 * @date 2020/1/7 20:04
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerPromotionQueryParam extends PageQuery {

    private static final long serialVersionUID = -4425264784093852713L;

    /**
     * 主键
     */
    private Long id;

    /**
     *代理人id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 优惠金额
     */
    private Integer amount;

    /**
     * 类型
     * @see SellerPromotionTypeEnum
     */
    private Integer promotionType;

    /**
     * 状态
     * @see SellerPromotionStateEnum
     */
    private Integer state;

}
