package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateDetailDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateLinkedDetailDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateLinkedIdDto;
import cn.com.duiba.kjy.api.params.appvideo.AppVideoTemplateSearchParam;
import cn.com.duiba.kjy.api.params.appvideo.AppVideoTemplateSearchTypeParam;

import java.util.List;
import java.util.Map;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-09 14:25
 * 视频模板rpc
 */
@AdvancedFeignClient
public interface RemoteAppVideoTemplateApiService {

    /**
     * 查询视频模板列表（仅管理后台可用）
     * @param classificationId 栏目id（可为空）
     * @return 模板列表
     */
    long countTemplate(Long classificationId);

    /**
     * 批量统计栏目下的视频模板数量（仅管理后台可用）
     * @param classificationIds 栏目id
     * @return key栏目id value视频模板数量
     */
    Map<Long, Long> batchCountTemplate(List<Long> classificationIds);

    /**
     * 查询视频模板列表（不带ext）
     * @param param 查询参数
     * @return 模板列表
     */
    List<AppVideoTemplateDto> searchListWithCache(AppVideoTemplateSearchParam param);

    /**
     * 根据模板分类和模板类型查询模板列表
     * @param param 查询参数 。必须含有视频类型，否则不予查询。
     * @return 模板列表
     * @deprecated 参数进行重新封装 {@link #searchListByTypeWithCacheV2}
     */
    @Deprecated
    List<AppVideoTemplateDto> searchListByTypeWithCache(AppVideoTemplateSearchParam param);

    /**
     * 根据模板分类和模板类型查询模板列表
     * 此方法的cache已经取消，本方法原本只为兼容低版本使用，后续此场景将会成为小众群体，故取消cache
     * @param param 查询参数 。必须含有视频类型，否则不予查询。
     * @return 模板列表
     */
    List<AppVideoTemplateDto> searchListByTypeWithCacheV2(AppVideoTemplateSearchTypeParam param);

    /**
     * 获取当前视频模板（带ext）
     * 管理后台专用
     * @param param 查询参数
     * @return 视频模板及ext信息
     */
    List<AppVideoTemplateDetailDto> searchDetailList(AppVideoTemplateSearchParam param);

    /**
     * 查询视频模板列表（只有视频类型为普通的视频模板）
     * @param param 查询参数。必须含有视频类型，否则不予查询。
     * @return 模板列表
     * @deprecated 此接口功能过于单一，不符合逻辑，后续请使用{@link #searchListByTypeWithCache}方法
     */
    @Deprecated
    List<AppVideoTemplateDto> searchListOnlyVideoWithCache(AppVideoTemplateSearchParam param);

    /**
     * 获取当前视频模板
     * @param templateId 模板id
     * @return 视频模板及ext信息
     */
    AppVideoTemplateDetailDto findDetailById(Long templateId);


    /**
     * 获取当前视频模板（包含前一个后一个id）
     * @param templateId 模板id
     * @return 视频模板及ext信息
     * @deprecated 此方法失效，后续推荐使用{@link #findDetailById}方法，其他数据请调用其他接口获取后自行组装
     */
    @Deprecated
    AppVideoTemplateLinkedDetailDto findLinkedDetailById(Long templateId);

    /**
     * 根据类型查询指定分类下的 上一个 & 下一个 模板
     * @param templateId 指定模板ID
     * @param classificationId 指定栏目ID
     * @param videoTypeList 模板类型列表 null： 不区分类型，查询所有范围。
     *                      为了兼容不同的版本而设计的参数。根据版本支持的类型，传入不同的列表
     * @return 指定分类下的 上一个 & 下一个 模板
     */
    AppVideoTemplateLinkedIdDto findLinkById(Long templateId,Long classificationId,List<Integer> videoTypeList);

    /**
     * 伪造一个上一个/下一个功能，为了应对中间版本的bug问题。
     * @param templateId 当前模版ID
     * @param videoTypeList 模版类型列表
     * @return 上一个& 下一个
     */
    AppVideoTemplateLinkedIdDto findForgeLinkById(Long templateId,List<Integer> videoTypeList);

    /**
     * 新增视频模板
     * @param insertDetail 视频模板
     * @return 视频模板id
     */
    boolean insert(AppVideoTemplateDetailDto insertDetail);

    /**
     * 编辑视频模板
     * @param updateDetail 视频模板
     * @return 编辑结果
     */
    boolean update(AppVideoTemplateDetailDto updateDetail);

    /**
     * 批量修改视频模板
     * 原方法，只是为了修改排序，弄个全属性批量修改，简直了！现废弃！！！
     * @param updateList 模板id
     * @return 批量修改结果
     */
    @Deprecated
    int batchUpdate(List<AppVideoTemplateDto> updateList);

    /**
     * 删除视频模板
     * @param id 模板id
     * @return 删除结果
     */
    boolean deleteById(Long id);

    /**
     * 排序
     * @param classifyId 栏目ID
     * @param templateId 模板ID
     * @param moveType 上移/下移
     */
    void sort(Long classifyId, Long templateId, int moveType);
}
