package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerDynamicUserVisitDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.seller.SellerDynamicVisitSearchParams;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2020-05-14 16:22
 * @description: 销售动态访客记录
 */
@AdvancedFeignClient
public interface RemoteSellerDynamicUserVisitService {

    /**
     * 添加访客记录
     * @param scId
     * @param userId
     * @param forwardTime
     * @return
     */
    Boolean addUserVisit(Long scId,Long userId,Date forwardTime);

    /**
     * 销售动态访客列表
     * @param params
     * @return
     */
    Page<SellerDynamicUserVisitDto> selectList(SellerDynamicVisitSearchParams params);

}
