package cn.com.duiba.kjy.api.remoteservice.sellergift;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerGift.SellerGiftBatchDto;
import cn.com.duiba.kjy.api.dto.sellerGift.SellerGiftDetailDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.sellerGift.AddBatchParam;
import cn.com.duiba.kjy.api.params.sellerGift.SellerGiftPageQueryParam;

import java.util.List;

/**
 * 功能描述：用户奖励发放
 *
 * @Auther: xiaotian
 * @Date: 2020/6/16 15:26
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteSellerGiftService {

    /**
     * 创建奖励发放批次
     *
     * @param addBatchParam
     * @return
     */
    Long createBatch(AddBatchParam addBatchParam);


    /**
     * 获取批次详情
     *
     * @param id
     * @return
     */
    SellerGiftBatchDto getById(Long id);


    /**
     * 修改批次数据
     *
     * @param dto 批次数据
     * @return 处理结果
     */
    boolean updateBatch(SellerGiftBatchDto dto);


    /**
     * 管理端筛选列表
     *
     * @param pageQuery
     * @return
     */
    Page<SellerGiftBatchDto> queryPage(PageQuery pageQuery);


    /**
     * 管理端根据批次ID筛选明细列表
     *
     * @param sellerGiftPageQueryParam
     * @return
     */
    Page<SellerGiftDetailDto> querySellerPage(SellerGiftPageQueryParam sellerGiftPageQueryParam);


    /**
     * 根据详情主键ID，获取详情
     *
     * @param id
     * @return
     */
    SellerGiftDetailDto selectById(Long id);


    /**
     * 批量修改
     *
     * @param sellerGiftDetailDtos
     * @return
     */
    boolean batchUpdate(List<SellerGiftDetailDto> sellerGiftDetailDtos);

    /**
     * 发放奖励
     *
     * @param ids
     * @return
     */
    boolean grantGift(List<Long> ids);


    /**
     * 删除详情
     *
     * @param id
     * @return
     */
    boolean delDetail(Long id);

}
