package cn.com.duiba.kjy.api.dto.classify;

import cn.com.duiba.kjy.api.dto.tag.TagDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-07-08.
 */
@Data
public class ClassifyContentDto implements Serializable {
    private static final long serialVersionUID = 387036793642772285L;

    private Long id;
    private Long contentId;
    private String contentType;
    private Long companyId;
    private String companyName;
    private List<TagDto> tagList;
    private String contentTag;
    private Integer clickTimes;
    private Long classifyId;
    private String dataTag;
    private String systemDataTag;
    private Integer payLoad;
    private String recommendText;
    private Long redirectNum;
    private String mainUrl;
    private Boolean open;
    private String title;
    private Integer publicly;
    private String contentText;
    private Boolean isBatchPoster;
    private Boolean isLocked;
    private Date releaseTimes;
    /**
     * 批量海报
     */
    private List<PosterContent> posters;
    private List<Long> contentBatchIds;
    private Boolean isOpenTiming;
    private Date closeTimes;

    /**
     *
     *首页配图，多图“,”隔开
     */
    private String homeImgUrl;

    /**
     * 素材版本
     * @see cn.com.duiba.kjy.api.enums.version.ContentVersionEnum
     */
    private Integer contentVersion;

    @Data
    public static class PosterContent implements Serializable {

        private static final long serialVersionUID = 1603053014153483741L;

        /**
         * 图片地址
         */
        private String picUrl;
        /**
         * 内容地址
         */
        private Long contentId;

    }
}
