package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业活动完成明细表
 * @author kjj mybatis generator 
 * 2021-10-29
 */
@Data
public class CorpActivityCompleteDetailDto implements Serializable {
    private static final long serialVersionUID = 16354871451152998L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *活动ID，tb_corp_activity.id
     * not null default = null
     */
    private Long activityId;

    /**
     *
     *公司ID，tb_corp_company.id
     * not null default = null
     */
    private Long companyId;

    /**
     *
     *工号
     * max length = 200
     * not null default = null
     */
    private String jobNumber;

    /**
     *
     *完成结果,1-已查看 2-参加 3-不参加
     * not null default = null
     * {@link cn.com.duiba.kjy.api.enums.corp.ActivityCompleteResultEnum}
     */
    private Integer completeResult;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}