package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 企业活动信息表
 *
 * @author kjj mybatis generator
 * 2021-10-29
 */
@Data
public class CorpActivityDto implements Serializable {
    private static final long serialVersionUID = 16354871142714410L;

    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 公司ID，tb_corp_company.id
     * not null default = null
     */
    private Long companyId;

    /**
     * 活动名称
     * max length = 50
     * not null default =
     */
    private String activityName;

    /**
     * 活动描述
     * max length = 255
     * not null default =
     */
    private String activityDesc;

    /**
     * 活动封面
     */
    private List<String> activityCoverList;

    /**
     * 活动状态,1未开始 2进行中 3已完成
     * not null default = 1
     * {@link cn.com.duiba.kjy.api.enums.corp.ActivityStatusEnum}
     */
    private Integer activityState;

    /**
     * 是否上架,1上架 0下架
     * not null default = 1
     * {@link cn.com.duiba.kjy.api.enums.corp.ActivityShelfStatusEnum}
     */
    private Integer shelfState;

    /**
     * 接收活动的营业部ID集合
     * max length = 1024
     * not null default =
     */
    private List<Long> sendDeptIdList;

    /**
     * 创建人ID，tb_corp_staff.id
     * not null default = null
     */
    private Long creatorId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;
}