package cn.com.duiba.kjy.api.enums.exclusive;

import cn.com.duiba.kjy.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 公司专区赠险类型枚举
 *
 * @author ZhangJun
 * @date 2021/11/25 8:43 下午
 */
@Getter
@AllArgsConstructor
public enum ExclusiveInsuranceTypeEnum {

    PERSONAL_ACCIDENT(1, "人身意外险"),
    HEAVY_DISEASE(2, "重疾险"),
    EPIDEMIC_RISK(3, "疫情险"),
    MEDICAL_TREATMENT(4, "医疗险"),
    ;

    private Integer type;

    private String desc;

    private static final Map<Integer, ExclusiveInsuranceTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ExclusiveInsuranceTypeEnum item : values()){
            ENUM_MAP.put(item.getType(), item);
        }
    }

    public static ExclusiveInsuranceTypeEnum getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }

        return ENUM_MAP.get(type);
    }
}
