package cn.com.duiba.kjy.api.mqmsg;

import cn.com.duiba.kjy.api.enums.push.PushEventEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/7/6 6:26 PM
 */
@Data
public class KjjBatchPushMsg implements Serializable {

    private static final long serialVersionUID = -3713062033361779319L;

    /**
     * 客服消息 文字消息
     */
    public static final int TYPE_KEFU = 1;
    /**
     * 模板消息
     */
    public static final int TYPE_TEMPLATE = 2;
    /**
     * 图文客服消息
     */
    public static final int TYPE_KEFU_PIC_TEXT = 3;

    /**
     * 客服图片消息
     */
    public static final int TYPE_KEFU_PIC = 4;

    /**
     * 客服小程序卡片消息
     */
    public static final int TYPE_KEFU_MP_CARD = 5;


    /**
     * 消息类型
     */
    private int type;

    /**
     * 公众号ID
     */
    private Long oaId;

    /**
     * 收信息的用户openId
     */
    private List<User4Message> users;

    /**
     * 消息关键信息，目前使用场景：
     * 1.作为模板消息id
     */
    private String key;

    /**
     * 模版消息的
     * 消息内容
     * json格式
     */
    private String body;

    /**
     * 图片消息要求图片必须上传至微信后台，推送时使用mediaID
     */
    private String mediaId;

    /**
     * 文字消息的文本内容
     */
    private String text;

    /**
     * 模板跳转链接
     */
    private String url;

    /**
     * 图文客服消息（卡片）
     */
    private KjjKefuPicTextMsg kjjKefuPicTextMsg;

    /**
     * 小程序卡片消息
     */
    private KjjKefuMpCardMsg kjjKefuMpCardMsg;

    /**
     * 推送类型
     * @deprecated {@link KjjBatchPushMsg#pushEvent}
     */
    @Deprecated
    private PushEventEnum pushEventEnum;

    /**
     * 推送类型
     */
    private cn.com.duiba.kjy.api.api.enums.PushEventEnum pushEvent;
}
