package cn.com.duiba.kjy.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.ActivityVisitStatDto;

/**
 * 访客参与活动统计
 * @author xuzhigang
 * @date 2021/07/27 3:54 pm
 */
@AdvancedFeignClient
public interface RemoteActivityVisitStatService {

    /**
     * 根据活动id和访客id查询
     *
     * @param activityId 活动id
     * @param visitId 访客id
     * @return 执行结果
     */
    ActivityVisitStatDto selectByActivityIdAndVisitId(Long activityId, Long visitId);

    /**
     * 新增参与次数
     *
     * @param id 主键id
     * @return 执行结果
     */
    int increaseJoinTimes(Long id);

    /**
     * 插入统计记录
     *
     * @param dto 统计记录
     * @return 执行结果
     */
    int insert(ActivityVisitStatDto dto);
}