package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoPhotoFrameDto;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoPhotoFrameRelationDto;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoTemplateDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateMigrateDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-17 20:28
 */
@AdvancedFeignClient
public interface RemoteMigrateTemplateService {

    /**
     * 迁移数据（仅限task-center使用）
     * @param list 需要迁移的数据
     */
    void migrate(List<AppVideoTemplateMigrateDto> list);

    /**
     * 获取所有视频模板
     * @return 视频模板
     */
    List<AiVideoTemplateDto> listAllTemplate();

    /**
     * 获取关联信息
     * @param templateIds 模板id
     * @return 关联信息
     */
    List<AiVideoPhotoFrameRelationDto> listRelationByTemplateIds(List<Long> templateIds);

    /**
     * 获取相框
     * @param frameIds 相框id
     * @return 相框
     */
    List<AiVideoPhotoFrameDto> listFrameByIds(List<Long> frameIds);
}
