package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpActivityDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.corp.ActivityEsPageListParam;

/**
 * 活动
 *
 * @author xuzhigang
 * @date 2021/10/29 2:51 下午
 **/
@AdvancedFeignClient
public interface RemoteCorpActivityService {

    /**
     * 根据活动id查询活动
     *
     * @param id 活动id
     * @return 活动信息
     */
    CorpActivityDto findById(Long id);

    /**
     * ES分页查询活动列表
     *
     * @param param 分页查询参数
     * @return 分页查询结果
     */
    Page<CorpActivityDto> selectPageFromEs(ActivityEsPageListParam param);

    /**
     * 更新
     *
     * @param dto 活动信息
     * @return 执行结果
     */
    Boolean update(CorpActivityDto dto);

    /**
     * 新增
     *
     * @param dto 活动信息
     * @return 活动ID
     */
    Long insert(CorpActivityDto dto);
}
