package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper.SingleWxMessageWrapperDto;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2021/4/14 11:18
 */
@AdvancedFeignClient
public interface RemoteVisitorMaterialPushTaskService {

    /**
     * 修改访客线索推送任务数据
     * @param ids 主键id集合
     * @param stage 当前阶段值，可以为空，为空则finish必须为true
     * @see cn.com.duiba.kjy.api.enums.push.VisitorMaterialPushStageEnum
     * @param finish 是否已结束
     * @return 执行结果
     */
    int batchChangeStage(List<Long> ids, Integer stage, boolean finish);

    /**
     * 保存单条推送消息
     * @param sellerId 销售员id
     * @param dto 推送消息
     * @return 执行结果
     */
    int save(Long sellerId, SingleWxMessageWrapperDto dto);

}
