package cn.com.duiba.kjy.api.remoteservice.wechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.wechat.WxPushRecordDto;

import java.util.List;


/**
 * 微信推送记录服务
 * @author zhanghuifeng
 * date 2019/12/6-6:01 下午
 */
@AdvancedFeignClient
public interface RemoteWxPushRecordService {

    /**
     * 保存（存在即更新最新一次推送时间）
     * @param dto
     * @return
     */
    Boolean saveExistUpdate(WxPushRecordDto dto);

    /**
     * 根据openId和推送类型查询今天的推送数
     * @param openId
     * @param pushEventTypes
     * @see cn.com.duiba.kjy.api.api.enums.PushEventEnum
     * @return
     */
    int countTodayByOpenIdAndType(String openId, List<String> pushEventTypes);
}
