package cn.com.duiba.kjy.api.constant;

/**
 * Created by xiaotian on 2020/12/18.
 */
public enum CommonStatusEnum {

    /**
     * 删除
     */
    DEL(-1,"删除"),
    /**
     * 关闭
     */
    CLOSE(0, "关闭"),
    /**
     * 开启
     */
    OPEN(1, "开启"),
    ;

    private Integer code;
    private String desc;

    CommonStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CommonStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CommonStatusEnum typeEnum : CommonStatusEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
