package cn.com.duiba.kjy.api.dto.clue;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员客户线索表
 *
 * @author kjj mybatis generator
 * 2021-12-23
 */
@Data
public class SellerVisitorClueDto implements Serializable {

    private static final long serialVersionUID = 16402495263307216L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 访客Id
     */
    private Long visitorId;

    /**
     * 代理人内容Id
     */
    private Long scid;

    /**
     * 用户访问id
     */
    private Long userVisitId;

    /**
     * 线索类型 具体含义见ClueBizTypeEnum
     * @see cn.com.duiba.kjy.api.enums.clue.ClueBizTypeEnum
     */
    private Integer clueBizType;

    /**
     * 不同线索对应的业务id
     */
    private Long clueBizId;

    /**
     * 来源的代理人内容id
     */
    private Long sourceScid;

    /**
     * 0:未跟进 1:已跟进
     */
    private Integer hasFollowed;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}