package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 企业版-公司信息配置表
 *
 * @author kjj mybatis generator
 * 2021-10-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CorpCompanyDto extends SimpleCorpCompanyDto {
    private static final long serialVersionUID = 1635241359006182L;

    /**
     * 公司logo
     * max length = 255
     * not null default =
     */
    private String companyLogo;

    /**
     * 公司等级：1-总公司，2-分公司，3-支分公司
     * not null default = 1
     * {@link cn.com.duiba.kjy.api.enums.corp.CorpCompanyLevelEnum}
     */
    private Integer companyLevel;

    /**
     * 权限到期时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date authExpiryDate;

    /**
     * 员工数量上限
     * not null default = 0
     */
    private Integer employeeNum;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;
}