package cn.com.duiba.kjy.api.enums.novice;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2019-09-05 13:55
 * @descript
 */
public enum NoviceTaskEnum {
    SUBSCRIBE_VIP(1L, "关注导师微信和客集集VIP公众号", "去关注", "领奖励", "已完成"),
    FORWARD_ARTICLE(2L, "转发一篇文章到朋友圈", "去转发", "领奖励", "已完成"),
    FORWARD_ANIMATION(3L, "转发一篇动画到朋友圈", "去转发", "领奖励", "已完成"),
    UPLOAD_ARTICLE_THEN_FORWARD(4L, "上传一篇文章并转发到朋友圈", "去上传", "领奖励", "已完成"),
    EDIT_CARD(5L, "完善名片信息", "去完善", "领奖励", "已完成"),
    VISIT_INFO_AND_CHECK_CUSTOMER(6L, "收到一条访问通知并查看客户信息", "去查看", "领奖励", "已完成"),
    /**
     * 任务已废弃
     */
    USER_FORWARD_VISIT_INFO(7L, "收到一条好友转发带来的访问通知", "待完成", "领奖励", "已完成"),
    /**
     * 任务已废弃
     */
    INVITE_FRIEND(8L, "邀请3个保险行业好友首次关注客集集公众号", "去邀请", "领奖励", "已完成"),
    FORWARD_POSTER(9L, "保存一张海报并转发到朋友圈", "去转发", "领奖励", "已完成"),
    FORWARD_GAME(10L, "转发一个游戏到朋友圈", "去转发", "领奖励", "已完成"),
    FINISH_COURSE_LEARNING(11L, "进入客集集商学院并完成一门课程学习", "去学习", "领奖励", "已完成"),
    INVITE_FRIEND_BE_VIP(12L, "邀请好友开通客集集会员", "去邀请", "领奖励", "已完成"),
    ;

    private Long id;
    private String describe;
    private String status0Description;
    private String status1Description;
    private String status2Description;

    NoviceTaskEnum(Long id, String describe, String status0Description, String status1Description, String status2Description) {
        this.id = id;
        this.describe = describe;
        this.status0Description = status0Description;
        this.status1Description = status1Description;
        this.status2Description = status2Description;
    }

    public Long getId() {
        return id;
    }

    public String getDescribe() {
        return describe;
    }

    public static String getDescriptionByTaskIdAndStatus(Long taskId, Integer status) {
        NoviceTaskEnum e = null;
        for (NoviceTaskEnum noviceTaskEnum : NoviceTaskEnum.values()) {
            if (Objects.equals(noviceTaskEnum.getId(), taskId)) {
                e = noviceTaskEnum;
                break;
            }
        }
        if (Objects.isNull(e)) {
            return "";
        }
        if (SellerNoviceTaskStatusEnum.NOT_COMPLETE.getCode() == status) {
            return e.status0Description;
        }
        if (SellerNoviceTaskStatusEnum.REWARDED.getCode() == status) {
            return e.status1Description;
        }
        if (SellerNoviceTaskStatusEnum.COMPLETED.getCode() == status) {
            return e.status2Description;
        }
        return "";
    }
}
