package cn.com.duiba.kjy.api.enums.sms;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 阿里云短信模版枚举
 * 模版需要申请，通过在阿波罗及本枚举配置方可使用
 * {@link cn.com.duiba.kjy.config.SmsConfig#msgTemplateMap}
 *
 * @author ZhangJun
 * @date 2021/11/17 11:12 上午
 */
@Getter
@AllArgsConstructor
public enum SmsTemplateTypeEnum {

    /**
     * 太保社群短信验证码模版
     * {@link cn.com.duiba.kjy.api.bean.sms.TaiBaoCommunityVerificationParamBean}
     */
    TAIBAO_COMMUNITY_VERIFICATION(1, "太保社区报名表单短信验证码"),

    /**
     * 报名成功通知短信
     * {@link cn.com.duiba.kjy.api.bean.sms.LinkUrlParamBean}
     */
    APPLY_SUCCESS_NOTICE(2, "报名成功通知短信"),

    /**
     * OTO-销售工作台-登录-短信验证码
     * {@link cn.com.duiba.kjy.api.bean.sms.OtoLoginVerificationParamBean}
     */
    OTO_LOGIN_VERIFICATION(3, "OTO-销售工作台登录短信验证码"),

    /**
     * 跟拍助手登录验证码
     * {@link cn.com.duiba.kjy.api.bean.sms.AppLoginCaptchaBean}
     */
    APP_LOGIN_VERIFICATION(4, "跟拍助手登录验证码"),
    ;

    /**
     * 模版类型
     */
    private final Integer templateType;

    /**
     * 模版描述
     */
    private final String templateDesc;

    private static final Map<Integer, SmsTemplateTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SmsTemplateTypeEnum::getTemplateType, Function.identity())));
    }

    public static SmsTemplateTypeEnum getByType(Integer templateType) {
        if (Objects.isNull(templateType)) {
            return null;
        }

        return ENUM_MAP.get(templateType);
    }


}
