package cn.com.duiba.kjy.api.params.wx.tag;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信公众号用户标签表
 * @author kjj mybatis generator 
 * @date 2020-09-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxTagSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16013593967016903L;

    /**
     * 标签所属公众号主键，tb_official_accounts.id
     */
    private Long oaId;

    /**
     * 标签类型，1-直播非VIP，2-直播VIP
     * @see cn.com.duiba.kjy.api.enums.wx.WxTagTypeEnum
     */
    private Integer tagType;

    /**
     * 微信标签ID
     */
    private String wxTagId;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;
}