package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interview.InterviewEvaluationDto;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-09-06 14:39
 * 面访评价
 */
@AdvancedFeignClient
public interface RemoteInterviewEvaluationApiService {

    /**
     * 获取面访评价
     * @param sellerId 销售id
     * @param evaUserId 评价用户id
     * @param evaDate 评价日期
     * @return 面访评价
     */
    InterviewEvaluationDto findBySidAndUidAndDate(Long sellerId, Long evaUserId, Integer evaDate);

    /**
     * 新增面访评价
     * @param dto 面访评价
     * @return 新增结果
     */
    int insert(InterviewEvaluationDto dto);
}
