package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoPhotoFrameRelationDto;

import java.util.List;
import java.util.Map;

/**
 * ai跟拍视频相框关联关系remoteService
 *
 * @author ZhangJun
 * @create 2021/5/23 8:53 下午
 */
@AdvancedFeignClient
public interface RemoteAiVideoPhotoFrameRelationService {

    /**
     * 根据视频模版id查询视频与相框的关联关系
     *
     * @param videoTemplateId 视频模版id
     * @return 视频与相框的关联关系
     */
    List<AiVideoPhotoFrameRelationDto> getRelationsByVideoTemplateId(Long videoTemplateId);

    /**
     * 批量建立视频与相框的关联关系
     *
     * @param videoTemplateId 视频模版id
     * @param photoFrameIds   相框id集合
     * @return 建立关系是否成功
     */
    boolean addRelations(Long videoTemplateId, List<Long> photoFrameIds);

    /**
     * 批量删除视频与相框的关联关系
     *
     * @param videoTemplateId 视频模版id
     * @return 删除视频与相框的关联关系
     */
    boolean deleteRelations(Long videoTemplateId);


    /**
     * 批量查询视频关联相框的数量
     *
     * @param videoTemplateIds 视频模版id集合
     * @return 视频相框关联的相框数量map
     */
    Map<Long, Integer> batchSelectVideoRelationCount(List<Long> videoTemplateIds);

}
