package cn.com.duiba.kjy.api.remoteservice.bank.direct.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.bank.direct.red.DirectRedRecordDto;
import cn.com.duiba.kjy.api.params.bank.direct.red.DirectRedRecordParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/12/21 11:02
 * @description 银行个金 - 直接发红包 RPC Service
 */
@AdvancedFeignClient
public interface RemoteDirectRedRecordApiService {

    /**
     * 根据条件查询记录列表
     *
     * @param param 查询参数
     * @return 记录列表
     */
    List<DirectRedRecordDto> selectList(DirectRedRecordParam param);

    /**
     * 根据条件查询记录的总记录数
     *
     * @param param 查询参数
     * @return 总记录数
     */
    Long selectCount(DirectRedRecordParam param);

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 直接发红包记录
     */
    DirectRedRecordDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 直接发红包记录
     * @return 新增结果
     */
    int insert(DirectRedRecordDto dto);

    /**
     * 更新
     *
     * @param dto 直接发红包记录
     * @return 更新结果
     */
    int update(DirectRedRecordDto dto);


}
