package cn.com.duiba.kjy.api.dto.redpacket.attend;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-27 18:12
 * 签到领红包-金额规则
 */
@Data
public class AttendRedAmountRuleDto implements Serializable {

    private static final long serialVersionUID = -5218202098919735202L;

    /**
     * 当前轮次
     */
    private Integer currentRound;

    /**
     * 随机金额下限
     */
    private Integer minMoney;

    /**
     * 随机金额上限
     */
    private Integer maxMoney;

    /**
     * 额外金额上限
     */
    private Integer extraMoneyLimit;

    /**
     * 额外金额/访客换算比
     */
    private Integer extraRate;

    /**
     * 是否为大红包
     */
    private Boolean bigRedFlag;

    /**
     * 大红包随机金额下限
     */
    private Integer bigMinMoney;

    /**
     * 大红包随机金额上限
     */
    private Integer bigMaxMoney;

    /**
     * 大红包可领次数（-1为无限制）
     */
    private Integer bigReceiveTime;

    /**
     * 大红包上限
     */
    private Integer bigMoneyLimit;

    /**
     * 大红包金额/访客换算比
     */
    private Integer bigRate;

}
