package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyBizTypeDto;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyDetailDto;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyDto;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyLevelDto;
import cn.com.duiba.kjy.api.dto.corp.SimpleCorpCompanyDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.corp.CompanyPageQueryParam;

import java.util.List;

/**
 * 企业后台-公司管理
 *
 * @author ZhangJun
 * @date 2021/10/27 10:29 上午
 */
@AdvancedFeignClient
public interface RemoteCorpCompanyService {

    /**
     * 通过id集合查询企业信息
     *
     * @param ids id集合
     * @return 企业信息集合
     */
    List<CorpCompanyDto> listByIds(List<Long> ids);

    /**
     * 通过企业名称模糊查询企业信息
     *
     * @param companyName 企业名称
     * @return 公司信息
     */
    List<SimpleCorpCompanyDto> search(String companyName);

    /**
     * 分页查询公司列表
     *
     * @param param 分页查询参数
     * @return 分页查询
     */
    Page<CorpCompanyDto> pageList(CompanyPageQueryParam param);

    /**
     * 根据公司id查询公司详情
     *
     * @param id 公司id
     * @return 公司信息
     */
    CorpCompanyDetailDto findById(Long id);

    /**
     * 保存公司详情
     *
     * @param detailDto 公司详情
     * @return 保存结果
     */
    boolean save(CorpCompanyDetailDto detailDto);

    /**
     * 更新公司详情
     *
     * @param detailDto 公司详情
     * @return 保存结果
     */
    boolean update(CorpCompanyDetailDto detailDto);

    /**
     * 查询公司业务类型列表
     *
     * @return 业务类型列表
     */
    List<CorpCompanyBizTypeDto> listBizType();

    /**
     * 查询公司等级列表
     *
     * @return 公司等级列表
     */
    List<CorpCompanyLevelDto> listCompanyLevel();
}
